//
//
// SortedStringVector
//
//
// Author: Christophe Pallier (pallier@lscp.ehess.fr)
//
// used by SortedTextArea.java
//
//
//
//     Copyright (C) 1997  Christophe Pallier 
//     
//     This program is free software; you can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your option) any later version.
//     
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
//     
//     You should have received a copy of the GNU General Public License
//     along with this program; if not, write to the Free Software
//     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import java.util.Vector;

// only for main:
import java.io.DataInputStream;
import java.io.IOException;

public class SortedStringVector
{
	protected Vector vec=null;

	public SortedStringVector() { vec=new Vector(); }

	public void clearAll() { vec.removeAllElements(); }
	
	public int append(String a) { 
		boolean f=false;
		int pos = (vec.size()==0)?0:search(a,f); 
		if (pos>vec.size()) { vec.addElement(a); return vec.size(); } 
		else { vec.insertElementAt(a,pos); return pos; }
	}

	public int search(String a, boolean found) { 
		found=false;
		if (vec.size()==0) { return 0; }
		int max=vec.size()-1;
		if (a.compareTo((String)vec.elementAt(0))<0) { return 0; }
		if (a.compareTo((String)vec.elementAt(max))>0) { return max+1; }

		int inf=0;
		int sup=max;
		int mid=0;
		do {
			mid=(inf+sup)/2;
			String cur=(String)vec.elementAt(mid);
			int comp=a.compareTo(cur);
			if (comp==0) { found=true; return mid; }
			else if (comp<0) { sup=mid-1; } else { inf=mid+1; }
		} while ((!found)&&(inf<=sup));

		if (a.compareTo((String)vec.elementAt(mid))<0) { 
			return mid; 
		} 
		else { 
			return mid+1; 
		}
		
		//return -1;		//should never get there
	}
	
	public void suppress(int pos) { }
	
	public String toString() { 
		StringBuffer buf=new StringBuffer();
		for (int i=0;i<vec.size();i++) {
			buf.append((i>0)?"\n":"").append(vec.elementAt(i));
		}
		return new String(buf);
	}

	public String toStringRev() { 
		int max=vec.size()-1;
		StringBuffer buf=new StringBuffer(max*64);
		buf.append(vec.elementAt(max));
		for (int i=max-1;i>=0;i--) {
			buf.append("\n").append(vec.elementAt(i));
		}
		return new String(buf);
	}
	
	public static void main(String[] args) {
		SortedStringVector s=new SortedStringVector();
		DataInputStream in=new DataInputStream(System.in);
		try {
			for (String buf=in.readLine();buf!=null;buf=in.readLine()) {
				s.append(buf);
			}
		} catch (IOException e) {}
		System.out.println(s);
	}
}

