
//
//
// SortedTextArea. 
//
// Author: Christophe Pallier (pallier@lscp.ehess.fr)
//
// This is a utility class for diskusage.java
//
//
//
//     Copyright (C) 1997  Christophe Pallier 
//     
//     This program is free software; you can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your option) any later version.
//     
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
//     
//     You should have received a copy of the GNU General Public License
//     along with this program; if not, write to the Free Software
//     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import SortedStringVector;
import java.awt.TextArea;
import java.awt.Graphics;

// for main only:
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.IOException;
import java.awt.BorderLayout;

public class SortedTextArea extends TextArea
{
	SortedStringVector content=new SortedStringVector();
	boolean running=false;

	public SortedTextArea(int a,int b) {
		super(a,b);
	}
	
	public void clear() {
		content.clearAll();
		setText("");
	}

	public void appendSortRev(String a) {
		int pos=content.append(a);
/*		if (pos<=getRows()) { 
			setText(content.toStringRev()); 
		} else setText(getText()+"\n"+a);
	*/
		setText(content.toStringRev());
		show();
		repaint();
	}

	public void appendSort(String a) {
		int pos=content.append(a);
/*		if (pos<=getRows()) { 
			setText(content.toStringRev()); 
		} else setText(getText()+"\n"+a);
	*/
		setText(content.toString());
		show();
		repaint();
	}

	
	public void update(Graphics g) {
		paint(g); 
	}

	public static void main(String[] args) {
		Frame f=new Frame("SortedTextArea");
		boolean reverse=(args.length>0);
		f.setLayout(new BorderLayout());
		SortedTextArea list=new SortedTextArea(30,40);
		f.add("Center",list);
		f.pack();
		f.show();
		DataInputStream in=new DataInputStream(System.in);
		try {
			for (String line=in.readLine();line!=null;line=in.readLine()) {
			if (!reverse) list.appendSort(line); 
			else list.appendSortRev(line);
} } catch (IOException e) { System.err.println(e); }
	}
}

