//
//
// diskusagew
//
// a java appplication that displays sizes of subdirectories.
// This is a wrapper around the command line version provided in "diskusage.java"
//
// Author: Christophe Pallier (pallier@lscp.ehess.fr)
// Date 2 Nov. 1997
//
// Compatible: java/jdk 1.0.2
//
//
//     Copyright (C) 1997  Christophe Pallier 
//     
//     This program is free software; you can redistribute it and/or
//     modify it under the terms of the GNU General Public License
//     as published by the Free Software Foundation; either version 2
//     of the License, or (at your option) any later version.
//     
//     This program is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.
//     
//     You should have received a copy of the GNU General Public License
//     along with this program; if not, write to the Free Software
//     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import java.awt.*;
import java.io.*;

import java.util.StringTokenizer;
import diskusage;
import SortedTextArea;

class BrowseDialog extends FileDialog {
	private diskusagew par=null;
	
	BrowseDialog(diskusagew parent) {
		super(parent,"Browse filesystem",FileDialog.LOAD);
		par=parent;
		show();
	}
}

class OptPanel extends Dialog {
	private diskusagew par=null;
	
	Panel p=new Panel();
	Label l=new Label("Display dir. sizes in:");
	CheckboxGroup bg=new CheckboxGroup();
	Checkbox b=new Checkbox("b",bg,true);
	Checkbox k=new Checkbox("Kb",bg,false);
	Checkbox m=new Checkbox("Mb",bg,false);
	
	Panel p2=new Panel();
	Label l2=new Label("Set minimal size for inclusion:");
	TextField lim=new TextField(6);
	
	Panel p3=new Panel();
	Label bslab=new Label("Cluster size (in bytes):");
	TextField bsize=new TextField(6);
	
	Panel okp=new Panel();
	Button ok=new Button("OK");
	
	public OptPanel(diskusagew parent) {
		super(parent,"Options",false);
		par=parent;
		setLayout(new BorderLayout());
        
		p.add(l);
		if (par.getdiv()==1) b.setState(true);
		if (par.getdiv()==1024) k.setState(true);
		if (par.getdiv()==1024*1024) m.setState(true);
		p.add(b);
		p.add(k);
		p.add(m);
		
		
		lim.setText(new Integer(par.getlim()).toString());
		lim.setEditable(true);
		p2.add(l2);
		p2.add(lim);
		
		
		bsize.setText(new Integer(par.getblsize()).toString());
		bsize.setEditable(true);
		p3.add(bslab);
		p3.add(bsize);
		
		okp.add(ok);
		p3.add(okp);
		
		add("North",p);
		add("Center",p2);
		add("South",p3);
		
		pack();
		show();
		enable();
	}
	
	public boolean handleEvent(Event e) {
		if (e.id==Event.WINDOW_DESTROY) {
			try {
				par.setlim(Integer.parseInt(lim.getText()));
				par.setblsize(Integer.parseInt(bsize.getText()));
			} catch (NumberFormatException exp)
			{ 
				par.setlim(1); 
				lim.setText("????");
			}
			hide();
			par.enable();
			return true;
		}
		return super.handleEvent(e);
	}
	
	
	public boolean action(Event e, Object obj) {
		
        if (e.target.equals(ok) && e.id==Event.ACTION_EVENT) {
			try {
				par.setlim(Integer.parseInt(lim.getText()));
				par.setblsize(Integer.parseInt(bsize.getText()));
			} catch (NumberFormatException exp)
			{ 
				par.setlim(1); 
				lim.setText("????");
			}
			hide();
			par.enable();
			return true;
		} else 
			if (e.target.equals(b)) { 
			par.setdiv(1);
			return true;
		} else 
			if (e.target.equals(k)) { 
			par.setdiv(1024);
			return true;
		} else 
			if (e.target.equals(m)) { 
			par.setdiv(1024*1024);
			return true;
		} 
		if (e.target.equals(lim) && (e.id==Event.KEY_RELEASE) && (e.key==10)) {
			try {
				par.setlim(Integer.parseInt(lim.getText()));
			} catch (NumberFormatException exp)
			{ 
				par.setlim(1); 
				lim.setText("????");
			}
			
			return true;
		}
		return true;;
	}
}

class rundiskusage extends Thread {
	private diskusagew parent=null;
	private String dir=null;
	private int blsize=0;
	private String unit=null;
	private int div=0;
	private int lim=0;
	private SortedTextArea listing=null;
	private FontMetrics fm=null;
	private diskusage du=null;
	private Thread tdu=null;
	
	public rundiskusage(diskusagew par) {
		parent=par;
		dir=parent.getdir();
		blsize=parent.getblsize();
		unit=parent.getunit();
		div=parent.getdiv();
		lim=parent.getlim();
		listing=parent.getlisting();
		fm=parent.getfontmetrics();
		this.start();
	}
	
	public void run() {
		listing.clear();
		try {
			PipedInputStream ppin=new PipedInputStream();
			DataInputStream pin=new DataInputStream(ppin);
			PrintStream pout=new PrintStream(new PipedOutputStream(ppin));
			du=new diskusage(dir,blsize,pout);
			du.setpos(1);
			du.setdiv(div);
			tdu=new Thread(du);
			tdu.start();
			
			String sz=null;
			String dn=null;
			
			for (String line=pin.readLine();line!=null;line=pin.readLine()) { 
				StringTokenizer a=new StringTokenizer(line,"\t\n");
				sz=a.nextToken();
				dn=a.nextToken();
				if (Integer.parseInt(sz)>=lim) { 
					listing.appendSortRev(padleft(numspace(sz),80)+"  "+unit+"     "+dn); 
				}
			}
			
} catch (IOException e) { listing.appendText("***"+e.toString()); }
parent.signalendofscan();
	}

	public void stopit() {
		if (tdu!=null) tdu.stop();
		super.stop();
	}
	
	// Tool to RightJustify numbers in the 'size' column
	private String padleft(String h, int width) {
		StringBuffer bf=new StringBuffer();
		
		int ll=fm.stringWidth(h);
        int sw=fm.charWidth(' ');
		for (int i=0;i<(width-ll)/sw;i++) bf.append(" ");
		bf.append(h);
		return bf.toString();
	}
	
	// Tool to add spaces every 3 digits
	// e.g. '1234' -> '1 234'
	private static int min(int a,int b) { return (a<b)?a:b; }
	
	private static String strrev(String a) {
		StringBuffer buf=new StringBuffer(a.length());
		for (int i=a.length()-1;i>=0;i--) buf.append(a.charAt(i));
		return buf.toString();
	}
	
	private String numspace(String in) {
		String rev=strrev(in);
		StringBuffer buf=new StringBuffer(rev.length()+5);
		int len=rev.length();
		for (int i=0;i<len/3+1;i++) {
			if (i>0) buf.append(' ');
			buf.append(rev.substring(i*3,min(i*3+3,len))); 
		}
		return strrev(buf.toString());
	}
	
}

public class diskusagew extends Frame {
	// this class provides the graphic interface to rundiskusage
	
	static String instructions = 
		"Type a directory name in the 'dir' box above, and press 'Go!' to display\n" + 
		"the space occupied on disk by each of its subdirectories. The output\n"+
		"list is sorted in real time by order of decreasing size.\n\n"+
		"'Options' allow:\n"+
		"   - to set whether you want the display in bytes, Kilobytes or Megabytes;\n"+
		"   - to set a minimal size criterion for a directory to be displayed;\n"+
		"   - to specify the size of clusters used by your system to allocate\n"+
		"     disk space to files. This will yield a more accurate\n"+
		"     estimate of the real space occupied by the files.\n\n"+
		"'...' opens a 'filedialog' box that allow to browse the filesystem. Selecting\n"+
		"     a file and clicking 'Open' will set 'dir' to this file's directory.\n"+
		"     (Unfortunately, java does not provide a 'directory browsing' dialog box).\n\n"+
		"Note: Some versions of java for Windows do not accept [c:\\] and need [c:\\\\.]\n\n" + 
		"It does (necessarily) read your disk but makes\n"+
		"no attempt to write on it, nor to connect to the network.\n\n"+
		"                     Christophe Pallier (pallier@lscp.ehess.fr)\n"+
		"                     http://www.ehess.fr/centres/lscp/persons/pallier\n\n"+
		"Tech. notes:\n"+
		" - This program works fine with jdk 1.0.2 on Windows.\n"+
		"   I would appreciate any feedback on its working on onther systems.\n"+
		" - The text panel may have a limited size, which can truncate\n"+
		"   long displays. Set the 'minimal size' option to correct this problem."+
	"\n\nLICENSE:"+
     "This program is free software; you can redistribute it and/or\n"+
     "modify it under the terms of the GNU General Public License\n"+
     "as published by the Free Software Foundation; either version 2\n"+
     "of the License, or (at your option) any later version.\n\n"+
     
     "This program is distributed in the hope that it will be useful,\n"+
     "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"+
     "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"+
     "GNU General Public License for more details.\n\n"+
     
     "You should have received a copy of the GNU General Public License\n"+
     "along with this program; if not, write to the Free Software\n"+
     "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."
;
	
	rundiskusage ru=null;
	
	// visual components	
	Panel uppan=new Panel(); // Top control panel
	Label dirlab=new Label("dir:");
	TextField dname=new TextField(30);
	Button browse=new Button("...");
	Button go=new Button("Go!");
	Button optb=new Button("Options");
	Button help=new Button("Help");
	
	SortedTextArea listing=new SortedTextArea(40,50);
	
	Font ft=null;
	FontMetrics fm=null;
	
	// access to parameters
	
	public FontMetrics getfontmetrics() { return fm; }
	
	public SortedTextArea getlisting() { return listing; }
	
	// cluster size
	private int blsize=4096;
	public void setblsize(int bl) { blsize=bl; }
	public int getblsize() { return blsize; }
	
	// divider to display size in bytes (div=1), Kbytes (div=1024) 
	//                                       or Mb (div=1024*1024)
	private int div=1024; 
	public void setdiv(int d) { div=d; }
	public int getdiv() { return div; }
	public String getunit() { 
		switch (div) {
		case 1: return "b";
		case 1024: return "K";
		case 1024*1024: return "M";
		};
		return "";
	}
	
	// minimal size to include a directory on the list
	private int lim=0;
	public void setlim(int l) { lim=l; }
	public int getlim() { return lim; }
	
	public void setdir(String dir) { dname.setText(dir); }
	public String getdir() { return dname.getText(); }
	
	
	// constructor
	public diskusagew() {
		super("Disk usage");
		this.setLayout(new BorderLayout(5,5));
		
		ft=new Font("Dialog",Font.PLAIN,10);
		fm= getFontMetrics(ft);
		setFont(ft);
		
		// control panel
		uppan.setLayout(new FlowLayout());
		uppan.add(dirlab);
		uppan.add(dname);
		uppan.add(browse);
		uppan.add(go);
		uppan.add(optb);
		uppan.add(help);
		uppan.setBackground(Color.lightGray);
		
		// listing area 
		listing.setEditable(false);
		listing.setBackground(Color.white);
		
		this.add("North",uppan);
		this.add("Center",listing);
		this.pack();
		this.show();
		enablego();
	}
	
	void showHelp() {		
		listing.setText(instructions); 
	}
	
	public void signalendofscan() { 
		enablego(); 
	}
	
	private void enablego() {
		dname.enable();
		browse.enable();
		go.setLabel("Go!");
		go.enable();
		optb.enable();
		help.enable();
		dname.requestFocus();
		repaint();
		//System.err.println("Enable go");
	}
	
	private void disablego() {
		dname.disable();
		browse.disable();
		go.setLabel("Stop!");
		optb.disable();
		help.disable();
		repaint();
		//System.err.println("disable go");
	}
	
	
	public void start() {
        String dir = getdir();
		if (dir.length()==0) {
			listing.setText("You must supply a directory name in the above box.");
			dname.requestFocus();
			dname.selectAll();
			return;
		}
		
		if (!(new File(dir)).exists()) { 
			listing.setText("Cannot open [" + dir + "]"); 
			dname.requestFocus();
			dname.selectAll();
			return; 
		}
		
		disablego();
		ru=new rundiskusage(this);
	}
	
	public void stop() {
		if ((ru!=null)&&(ru.isAlive())) ru.stopit();
		listing.appendText("\n*** Interrupted by the user");
		listing.select(0,0);
		listing.repaint();
		enablego();
	}
	
	
	public boolean handleEvent(Event evt) {
		if  (evt.id==Event.WINDOW_DESTROY) {
			dispose();
			System.exit(0);
			return true;
		}
		return super.handleEvent(evt);
	}
	
	public boolean action(Event evt, Object obj) {
		
		if (evt.target instanceof Button) {
			String label=(String)obj;
			//System.out.println(label);
			if (label.equals("...")) {
				BrowseDialog bd=new BrowseDialog(this);
				dname.setText(bd.getDirectory());
				return true;
			}
			if  (label.equals("Go!")) {	
				if ((ru==null)||(!ru.isAlive())) start(); 
				else System.err.println("can't start");
				return true;
			}
			if (label.equals("Stop!")) {
				if ((ru!=null)&&ru.isAlive())  stop(); 
				else System.err.println("can't stop");
				if (ru!=null) while (ru.isAlive()) {};
				return true;
			}
			if  (label.equals("Help")) {
				showHelp();
				return true;
			}
			if (label.equals("Options")) {
				OptPanel optp=new OptPanel(this);
				optp.show();
				return true;
			}
		}
		return true;
	}
	
	static public void main(String[] arg) {
		diskusagew du=new diskusagew();
		if (arg.length>0) {
			du.setdir(arg[0]);
			if (arg.length>1) { 
				du.setdiv(Integer.parseInt(arg[1])); 
			}
			du.start();
		} else du.showHelp(); 
	}
	
} 


